//  jaQuzzi 0.1 - Interactive Quantum Computer Simulator    
//  Copyright (C) 2000  Felix Schuermann
//
//  This program is free software; you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation; either version 2 of the License, or
//  any later version.
//
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with this program; if not, write to the Free Software
//  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//  The author can be reached under: fschuermann@usa.net
//  
//  A full copy of the source can be obtained from: 
//  www.physics.buffalo.edu/~phygons/jaQuzzi

package edu.buffalo.fs7.qsymbol2;

import edu.buffalo.fs7.mathlib.*;

/**
 * interface implemented by the GateTable to handle steppable objects like the 
 * GateContainers. 
 * @see GateTable
 * @see GateContainer
 * @see Steppable
 */
public interface StepHandler {

    /**
     */
    public void stepForward();
    /**
     */
    public void stepBackward();
    /**
     */
    public int gotoStep(int step);
    public void reset();

    public int getStep();
    public int getStepCount();
}
