package maple;

import java.lang.reflect.*;
import java.io.*;
import java.net.*;

/**
 * This class is used to load java ressources at runtime
 * 
 */

public class DynamicClassLoader {

	private static final Class[] parameters = new Class[] { URL.class };

	/**
	 * Wrapper for files specified by a String
	 * @param s File as as String
	 * @throws IOException Thrown if the ressource cannot be accessed
	 */
	
	public static void add(String s) throws IOException {
		File f = new File(s);
		add(f);
	}

	/**
	 * Wrapper for files
	 * @param f The file
	 * @throws IOException Thrown if the ressource cannot be accessed
	 */
	
	public static void add(File f) throws IOException {
		add(f.toURL());
	}

	/**
	 * Loads a ressource at runtime
	 * @param url The URL of the ressource to load
	 * @throws IOException Thrown if the ressource cannot be accessed
	 */
	
	public static void add(URL url) throws IOException {

		URLClassLoader sysloader = (URLClassLoader) ClassLoader
				.getSystemClassLoader();
		Class sysclass = URLClassLoader.class;

		try {
			Method method = sysclass.getDeclaredMethod("addURL", parameters);
			method.setAccessible(true);
			method.invoke(sysloader, new Object[] { url });
		} catch (Throwable t) {
			t.printStackTrace();
			throw new IOException(
					"Error, could not add URL to system classloader");
		}

	}

}
