package maple;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;

import edu.buffalo.fs7.jaQuzzi.jaQuzzi;

public class InitMaple {
	/**
	 * Determines whether the required path variables are set correctly 
	 * @return true/false
	 */
	
	public static boolean checkMaplePathSet() {
		if (jaQuzzi.platformOS.contains("Win")) {
			// Windows 2000 and XP
			if (System.getenv("PATH").contains("bin.win")) {
				return true;
			} else {
				return false;
			}

		} else if (jaQuzzi.platformOS.contains("Mac")) {
			//Mac OS X
			if (System.getenv("MAPLE") != null && System.getenv("DYLD_LIBRARY_PATH") != null) {
				return true;
			} else {
				return false;
			}

		} else {
			// This is for standard Unix/Linux
			if (System.getenv("MAPLE") != null && System.getenv("LD_LIBRARY_PATH") != null) {
				return true;
			} else {
				return false;
			}
		}
	}
	
	/**
	 * Get the Maple Path from the settings file
	 * @return the Path
	 */
	
	public static String getMaplePath() {
		try {
			BufferedReader bR = new BufferedReader (new FileReader("settings.txt"));
			String result = bR.readLine();
			bR.close();
			return result;
		} catch (IOException e) {
			System.out.println("Settings.txt not found. If you want to use Maple please set correct path");
			return null;
		} 
	}
	
	/**
	 * Writes the path to the maple files in settings.txt
	 * @param path
	 * @return
	 */
	
	public static boolean writeMaplePath(String path) {
		try {
			BufferedWriter bW = new BufferedWriter (new FileWriter("settings.txt"));
			bW.write(path);
			bW.flush();
			bW.close();
			return true;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		} 
		
	}
	
	/**
	 * Loads maple libraries at runtime
	 * @param mapleBinPath The platform dependent path of the Maple libraries
	 */
	
	public static boolean loadMapleClasses(String mapleBinPath) {
		String maplePath;
		String mapleJavaPath;
		
		if (mapleBinPath != null && mapleBinPath.lastIndexOf(File.separator) > -1) {
			maplePath = mapleBinPath.substring(0, mapleBinPath.lastIndexOf(File.separator));
		} else {
			return false;
		}
		mapleJavaPath = maplePath + File.separator + "java";
		// Here we test if we got access to the required Java Librarys if not
		// quit
		File file = new File(mapleJavaPath + File.separator + "jopenmaple.jar");
		if (!file.exists()){
			System.out.println("The necessary Java class files in the Maple directory could not be found");
			return false;
		}
		try {
			DynamicClassLoader.add(mapleJavaPath + File.separator +"jopenmaple.jar" );
			DynamicClassLoader.add(mapleJavaPath + File.separator +"externalcall.jar" );
			return true;
		} catch (IOException e) {
			e.printStackTrace();
			return false;
		}
	}
	
	/**
	 * Creates batch files for the execution of Maple
	 * @param mapleBinPath
	 * @return
	 */
	
	public static String createBatchFiles(String mapleBinPath) {
		String maplePath;
		String mapleJavaPath;
		
		if (mapleBinPath.lastIndexOf(File.separator) > -1) {
			maplePath = mapleBinPath.substring(0, mapleBinPath.lastIndexOf(File.separator));
		} else {
			return null;
		}
		System.out.println(File.separator);
		mapleJavaPath = maplePath + File.separator +"java";
		// Here we test if we got access to the required Java Librarys if not
		// quit
		File file = new File(mapleJavaPath + File.separator +"jopenmaple.jar");
		if (!file.exists()){
			System.out.println("The necessary Java class files in the Maple directory could not be found");
			return null;
		}
		try {
			
			if (jaQuzzi.platformOS.contains("Win")) {
				//Windows 2000 and XP
				BufferedWriter bW = new BufferedWriter (new FileWriter("jaQuzzi.bat"));
				bW.write("SET PATH=%PATH%;" + mapleBinPath);
				bW.newLine();
				bW.write("java -jar jaQuzzi.jar\n");
				bW.flush();
				bW.close();
				return "jaQuzzi.bat";

			} else if (jaQuzzi.platformOS.contains("Mac")) {
				//Mac OS X
				BufferedWriter bW = new BufferedWriter (new FileWriter("jaQuzzi.sh"));
				bW.write("#!/bin/bash");
				bW.newLine();
				bW.write("export MAPLE=\"" + maplePath + "\"");
				bW.newLine();
				bW.write("export DYLD_LIBRARY_PATH=\"" + mapleBinPath + "\"");
				bW.newLine();
				bW.write("java -jar jaQuzzi.jar\n");
				bW.flush();
				bW.close();
				return "jaQuzzi.sh";
			
			} else {
				// This is for standard Unix/Linux
				BufferedWriter bW = new BufferedWriter (new FileWriter("jaQuzzi.sh"));
				bW.write("#!/bin/bash");
				bW.newLine();
				bW.write("export MAPLE=\"" + maplePath + "\"");
				bW.newLine();
				bW.write("export LD_LIBRARY_PATH=\"" + mapleBinPath + "\"");
				bW.newLine();
				bW.write("java -jar jaQuzzi.jar\n");
				bW.flush();
				bW.close();
				return "jaQuzzi.sh";
			}
			

		} catch (IOException e) {
			e.printStackTrace();
			return null;
		}
	}
}
