package maple;

import com.maplesoft.externalcall.MapleException;
import com.maplesoft.openmaple.Algebraic;

import edu.buffalo.fs7.mathlib.Complex;
import edu.buffalo.fs7.mathlib.Mathlib;

public class Ket {
	
	// The front factor of the Ket
	private String frontFactor;
	
	// The qubitSequenc
	private int[] qubitSequenz;
	
	// Determines whether we are in exact or approximate mode
	// This only effects the represenation of the output not the
	// internal calculations
	private static boolean exactMode = true;
	
	/**
	 * Toglles exactMode
	 * @return
	 */
	public static void toggleExactMode() {
		exactMode = !exactMode;
	}
	
	/**
	 * Default Constructor
	 *
	 */
	public Ket() {
		frontFactor = "0";
	}

	public int[] getQubitSequenz() {
		return qubitSequenz;
	}
	public void setQubitSequenz(int[] qubitSequenz) {
		this.qubitSequenz = qubitSequenz;
	}
	public String getFrontFactor() {
		return frontFactor;
	}
	public void setFrontFactor(String real) {
		this.frontFactor = real;
	}
	
	/**
	 * Returns the string representation
	 * @return String representation
	 */
	
	public String toString() {
		String result="";
		if (exactMode) {
			result = "(" + frontFactor  + ") *|" ;
		} else {
			try {
				int accuracy = (int)((Complex)Mathlib.getVar("MAPLEDIGITS")).re() ;
				if (accuracy > 10) {
					// We have to adjust the internal Maple accuracy
					MapleConnector.mapleEngine.evaluate("Digits:=" + accuracy + ":"); 
				}
				Algebraic temp = MapleConnector.mapleEngine.evaluate("evalf["+ (accuracy + 1) + "](" + frontFactor + "):");
				//System.out.println("evalf["+ (accuracy + 1) + "](" + frontFactor + "):");
				// We have round the result here
				//System.out.println("evalf["+ accuracy + "](round(" + temp.toString() + "*10^" + accuracy  +")/10^"+  accuracy + "):");
				result = "(" + MapleConnector.mapleEngine.evaluate("evalf["+ accuracy + "](round(" + temp.toString() + "*10^" + accuracy  +")/10^"+  accuracy + "):") +  ") *|";
				
			} catch (MapleException e) {
				e.printStackTrace();
			}
		}
		for (int i = 0; i < qubitSequenz.length; i++) {
			result += qubitSequenz[i];
		}
		result +=">";
		return result;
	}
	
	/**
	 * Creates an exact copy of a Ket
	 * @return The copy of the input Ket 
	 */
	
	public Ket copy() {
		Ket ket = new Ket();
		ket.setFrontFactor(frontFactor);
		int[] modifier = new int[qubitSequenz.length];
		for (int i=0;i < qubitSequenz.length;i++) {
			modifier[i] = qubitSequenz[i];
		}
		ket.setQubitSequenz(modifier);
		return ket;
	}
	

}
