package maple;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;

import com.maplesoft.externalcall.MapleException;
import com.maplesoft.openmaple.Engine;
import com.maplesoft.openmaple.EngineCallBacksDefault;

import edu.buffalo.fs7.jaQuzzi.jaQuzzi;

public class MapleConnector {
	
	/** Gives access to OpenMaple */
	
	/** Variables to initialize Maple */
	protected static String[] a = { "java" };

	public static Engine mapleEngine;
	
	public static LinkedHashMap<String, LinkedHashSet<Ket>> mapleStates = new LinkedHashMap<String, LinkedHashSet<Ket>>();
	
	public static LinkedHashSet<Ket> currentMapleState = new LinkedHashSet<Ket>(); 

	/**
	 * Initializes the connection to Maple and preloads required functions
	 * 
	 */
	public static void initializeMaple() {
		try {
			if (mapleEngine == null)
				mapleEngine = new Engine(a, new EngineCallBacksDefault(), null,
						null);
			jaQuzzi.mapleAvailable = true;
			// Prepare Kronecker function					
		} catch (MapleException exception) {
			System.out.println("Maple could not be initialized");
			jaQuzzi.mapleAvailable = false;
		}
	}

}
